IF  EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_TOP_SHOW_FP_FUNC]') 
					AND type in (N'U')) 
BEGIN
	DROP TABLE [dbo].[EST_TOP_SHOW_FP_FUNC]
END

/****** Object:  Table [dbo].[EST_TOP_SHOW_FP_FUNC]    Script Date: 19/12/2015 15:57:22 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON

CREATE TABLE [dbo].[EST_TOP_SHOW_FP_FUNC](
	[CD_EMP] [int] NOT NULL,
	[CD_TOP_SHOW] [int] NOT NULL,
	[CD_FILIAL]	  [int] NOT NULL,
	[CD_FUN]	  [int] NOT NULL,
	[CD_ARV_MERC_CLASSIFICACAO]	  [int] NOT NULL,
	[PERC_META]  [money] NOT NULL,
	[CD_USU] [int] not null,
	[DT_CAD]	[datetime],
	CONSTRAINT [PK_EST_TOP_SHOW_FP_FUNC] PRIMARY KEY CLUSTERED 
(
	[CD_ARV_MERC_CLASSIFICACAO],
	[CD_FUN],
	[CD_FILIAL],
	[CD_TOP_SHOW],
	[CD_EMP] 
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC] ADD  CONSTRAINT [DF_EST_TOP_SHOW_FP_FUNC_PERC_META]  DEFAULT ((0)) FOR PERC_META

ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC]  
	WITH CHECK ADD  CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_EST_TOP_SHOW_PRC_FILIAL] FOREIGN KEY([CD_TOP_SHOW],[CD_FILIAL],[CD_EMP])
REFERENCES [dbo].[EST_TOP_SHOW_PRC_FILIAL] ([CD_TOP_SHOW],[CD_FILIAL],[CD_EMP] )
ON UPDATE CASCADE
ON DELETE CASCADE 
ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC] CHECK CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_EST_TOP_SHOW_PRC_FILIAL]

ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC]  
	WITH CHECK ADD  CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_FP_FUNC] FOREIGN KEY([CD_EMP], [CD_FUN])
REFERENCES [dbo].[FP_FUNC] ([CD_EMP], [CD_FUN])
ON UPDATE CASCADE
ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC] CHECK CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_FP_FUNC] 
 
ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC]  
	WITH CHECK ADD  CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_EST_ARV_MERC_CLASSIFICACAO] FOREIGN KEY([CD_EMP], [CD_ARV_MERC_CLASSIFICACAO])
REFERENCES [dbo].[EST_ARV_MERC_CLASSIFICACAO] ([CD_EMP], [CD_ARV_MERC_CLASSIFICACAO])
ON UPDATE CASCADE

ALTER TABLE [dbo].[EST_TOP_SHOW_FP_FUNC] CHECK CONSTRAINT [FK_EST_TOP_SHOW_FP_FUNC_EST_ARV_MERC_CLASSIFICACAO]
